import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

const propTypes = {
    onClose: PropTypes.func,
    children: PropTypes.node,
};

export const POPUP_CLASS = classNames({
    'pl-notif': true,
    'pl-notif--with-triangle': false,
});

export const CLOSE_BUTTON_CLASS = classNames({
    'pl-close-button': true,
    'pl-notice__close': true,
});

export function NotificationPopUp({ children, onClose }) {
    return (
        <div
            className={POPUP_CLASS}
        >
            <button
                type="button"
                className={CLOSE_BUTTON_CLASS}
                onClick={onClose}
            >
                <svg className="pl-close-button__svg">
                    <use xlinkHref="#pl-icon_close" />
                </svg>
            </button>
            { children }
        </div>
    );
}

NotificationPopUp.propTypes = propTypes;
