import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const propTypes = {
    clickThroughUrl: PropTypes.string.isRequired,
    adLabel: PropTypes.string.isRequired,
    t: PropTypes.func.isRequired,
};

export function AdOverlayComponent({ clickThroughUrl, adLabel, t }) {
    /* eslint-disable jsx-a11y/anchor-has-content */
    return (
        <div>
            <div className="player-overlay player-ad-overlay">
                <a
                    className="player-ad-overlay"
                    target="_blank"
                    href={clickThroughUrl}
                />
            </div>
            <div className="player-ad-notice">
                <p className="js-advertisement-label"> {t(adLabel)}</p>
            </div>
        </div>
    );
    /* eslint-enable */
}

AdOverlayComponent.propTypes = propTypes;
export const AdOverlay = translate()(AdOverlayComponent);
