import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const propTypes = {
    deviceName: PropTypes.string.isRequired,
    t: PropTypes.func,
};

const defaultProps = {
    t() {},
};

export function ChromecastOverlayComponent({ deviceName, t }) {
    return (
        <div className="player-overlay pl-chromecast-overlay">
            <div className="player-center-content">
                <div>{t('Playing on {{deviceName}}', { deviceName })}</div>
            </div>
        </div>
    );
}

ChromecastOverlayComponent.propTypes = propTypes;
ChromecastOverlayComponent.defaultProps = defaultProps;
export const ChromecastOverlay = translate()(ChromecastOverlayComponent);
