import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const propTypes = {
    errorMessage: PropTypes.string.isRequired,
    errorCode: PropTypes.number.isRequired,
    t: PropTypes.func.isRequired,
};

export function ErrorOverlayComponent({ errorCode, errorMessage, t }) {
    return (
        <div className="pl-error">
            <div className="player-center-content">
                <p>{`${errorCode}: ${t(errorMessage)}`}</p>
            </div>
        </div>
    );
}

ErrorOverlayComponent.propTypes = propTypes;
export const ErrorOverlay = translate()(ErrorOverlayComponent);
