import React from 'react';
import PropTypes from 'prop-types';
import { UserOfflineOverlay } from 'ui/components/overlays/user-offline-overlay';

const propTypes = {
    shouldShowOfflineOverlay: PropTypes.bool,
};

const defaultProps = {
    shouldShowOfflineOverlay: false,
};

export function LoadingOverlay({ shouldShowOfflineOverlay }) {
    const offlineOverlay = shouldShowOfflineOverlay ? <UserOfflineOverlay /> : null;

    return (
        <div className="pl-overlay pl-overlay--loading">
            <div className="player-center-content">
                <div className="pl-loading-spinner" />
                {offlineOverlay}
            </div>
        </div>
    );
}

LoadingOverlay.propTypes = propTypes;
LoadingOverlay.defaultProps = defaultProps;
