import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Button } from 'ui/components/buttons/base-button';
import { translate } from 'react-i18next';

export const MATURE_WARNING_LABEL = 'The broadcaster indicated that the channel is intended for mature audiences.';
export const MATURE_ACCEPT_LABEL = 'Start Watching';
export const MATURE_LINK_ID = 'mature-link';
export const KEY_MATURE = 'mature';

const AGE_RESTRICTION_OVERLAY = classNames(
    'player-overlay',
    'pl-age-restriction-overlay--wall',
    'pl-age-restriction-overlay'
);

const PLAYER_CENTER_CONTENT = classNames(
    'player-center-content'
);

const MATURE_OVERLAY = classNames(
    'pl-mature-overlay'
);

const MATURE_WARNING_LABEL_CLASS = classNames(
    'js-mature-waring-label'
);

const MATURE_WARNING_BUTTON_CLASS = classNames(
    'player-content-button',
    'js-player-mature-accept',
    'js-mature-accept-label'
);

const propTypes = {
    handleMatureAccepted: PropTypes.func,
    t: PropTypes.func.isRequired,
};

export function MatureOverlayComponent({ handleMatureAccepted, t }) {
    return (
        <div className={AGE_RESTRICTION_OVERLAY}>
            <div className={PLAYER_CENTER_CONTENT}>
                <div className={MATURE_OVERLAY}>
                    <p className={MATURE_WARNING_LABEL_CLASS}>{t(MATURE_WARNING_LABEL)}</p>
                    <p>
                        <Button
                            className={MATURE_WARNING_BUTTON_CLASS}
                            id={MATURE_LINK_ID}
                            onClick={handleMatureAccepted}
                        >
                            {t(MATURE_ACCEPT_LABEL)}
                        </Button>
                    </p>
                </div>
            </div>
        </div>
    );
}

MatureOverlayComponent.propTypes = propTypes;
export const MatureOverlay = translate()(MatureOverlayComponent);
