import React from 'react';
import PropTypes from 'prop-types';
import { Button } from '../buttons/base-button';

const propTypes = {
    onClick: PropTypes.func.isRequired,
    collectionsSidebarOpen: PropTypes.bool,
};

const defaultProps = {
    collectionsSidebarOpen: false,
};

export function PlayButtonOverlay({ onClick, collectionsSidebarOpen }) {
    const button = collectionsSidebarOpen ? null : (
        <Button
            className="player-button player-button-play js-control-play-button"
            onClick={onClick}
        >
            <svg className="player-icon-play">
                <use xlinkHref="#icon_play" />
            </svg>
        </Button>
    );

    return (
        <div className="player-overlay player-play-overlay js-paused-overlay">
            {button}
        </div>
    );
}

PlayButtonOverlay.propTypes = propTypes;
PlayButtonOverlay.defaultProps = defaultProps;
