import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

// eslint-disable-next-line max-len
const QUALITY_RESTRICTED_TEXT = 'This video quality is only available to subscribers. Subscribe now to watch and support {{channelName}}.';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    subscribeUrl: PropTypes.string.isRequired,
    onClose: PropTypes.func,
    t: PropTypes.func,
};

const defaultProps = {
    tt: str => str,
};

export function QualityRestrictedComponent({ channelName, subscribeUrl, onClose, t }) {
    return (
        <div className="player-overlay player-overlay--wall pl-product-overlay">
            <div className="player-product-overlay__close js-player-product-close">
                <button
                    type="button"
                    className="player-button player-button--noscale player-button--close"
                    onClick={onClose}
                >
                    <svg>
                        <use xlinkHref="#icon_close_md" />
                    </svg>
                </button>
            </div>
            <div className="player-center-content player-product">
                <p>{t(QUALITY_RESTRICTED_TEXT, { channelName })}</p>
                <a href={subscribeUrl} target="_blank" className="purchase_button">
                    {t('Subscribe')}
                </a>
            </div>
        </div>
    );
}

QualityRestrictedComponent.propTypes = propTypes;
QualityRestrictedComponent.defaultProps = defaultProps;
export const QualityRestrictedOverlay = translate()(QualityRestrictedComponent);
