import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const propTypes = {
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    t() {},
};

export function StormWarningComponent({ t }) {
    return (
        <div className="pl-storm-warning">
            <div className="player-center-content">
                <div className="pl-loading-spinner" />
                <p>
                    <span className="broadcast-down-label">
                        {t('The broadcast is down.')}
                    </span><br />
                    <span className="broadcast-reload-label">
                        {t('The player will automatically reload when the broadcast is back.')}
                    </span>
                </p>
            </div>
        </div>
    );
}

StormWarningComponent.propTypes = propTypes;
StormWarningComponent.defaultProps = defaultProps;
export const StormWarningOverlay = translate()(StormWarningComponent);
