import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

// eslint-disable-next-line max-len
const SUBSCRIBER_ONLY_TEXT = 'This video is only available to subscribers. Subscribe now to watch and support {{channelName}}.';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    subscribeUrl: PropTypes.string.isRequired,
    t: PropTypes.func,
};

const defaultProps = {
    t() {},
};

export function SubscribeOverlayComponent({ channelName, subscribeUrl, t }) {
    return (
        <div className="pl-subscribe-overlay pl-subscribe-overlay--wall pl-product-overlay">
            <div className="player-center-content player-product">
                <p>{t(SUBSCRIBER_ONLY_TEXT, { channelName })}</p>
                <a href={subscribeUrl} target="_blank" className="purchase_button">
                    {t('Subscribe')}
                </a>
            </div>
        </div>
    );
}

SubscribeOverlayComponent.propTypes = propTypes;
SubscribeOverlayComponent.defaultProps = defaultProps;
export const SubscribeOverlay = translate()(SubscribeOverlayComponent);
