import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { makeAnimatedComponent } from 'ui/components/common/make-animated-component';
import classNames from 'classnames';

const propTypes = {
    onClick: PropTypes.func.isRequired,
    className: PropTypes.string.isRequired,
    t: PropTypes.func.isRequired,
};

const SHOW_HIDE_DURATION = 350; // ms

export function UnmuteOverlayComponent({ onClick, className, t }) {
    const CLASSES_UNMUTE_OVERLAY = classNames({
        'pl-overlay': true,
        'pl-overlay--unmute': true,
        [className]: true,
    });

    const icon = (
        <svg className="pl-overlay__icon--unmute">
            <use xlinkHref="#icon_volumemute" />
        </svg>
    );

    return (
        <div
            className={CLASSES_UNMUTE_OVERLAY}
            onClick={onClick}
            onKeyUp={onClick}
            role="button"
            tabIndex={-1}
        >
            <div className="pl-overlay__center-content">
                {icon}
                <p className="pl-overlay__text--unmute">
                    {t('Tap to unmute')}
                </p>
            </div>
        </div>
    );
}

UnmuteOverlayComponent.propTypes = propTypes;
const TranslatedUnmuteOverlay = translate()(UnmuteOverlayComponent);
export const AnimatedUnmuteOverlay = makeAnimatedComponent(TranslatedUnmuteOverlay, {
    showDuration: SHOW_HIDE_DURATION,
    hideDuration: SHOW_HIDE_DURATION,
    showClass: 'pl-overlay--transition-in',
    hideClass: 'pl-overlay--transition-out',
});
