import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const USER_OFFLINE_MESSAGE = 'You seem to be offline. Please wait while we try to reconnect.';

const propTypes = {
    t: PropTypes.func.isRequired,
};

export function UserOfflineOverlayComponent({ t }) {
    return (
        <div>
            <p>{t(USER_OFFLINE_MESSAGE)}</p>
        </div>
    );
}

UserOfflineOverlayComponent.propTypes = propTypes;

export const UserOfflineOverlay = translate()(UserOfflineOverlayComponent);
