import React from 'react';
import PropTypes from 'prop-types';
import { toArray } from '../../../../util/timestamp';

const propTypes = {
    date: PropTypes.object.isRequired,
    length: PropTypes.number.isRequired,
    languageCode: PropTypes.string.isRequired,
};

const LOCALE_DATE_OPTIONS = {
    year: 'numeric',
    month: 'short',
    day: 'numeric',
};

export const InfoDateLength = ({
    length,
    date,
    languageCode,
}) => {
    const formattedDate = date.toLocaleDateString(languageCode, LOCALE_DATE_OPTIONS);
    const [
        hours,
        minutes,
        seconds,
    ] = toArray(length, false);
    const formattedVideoLength = `${hours}:${minutes}:${seconds}`;

    return (
        <div>
            <span>{formattedDate}</span>&nbsp;&middot;&nbsp;
            <span>{formattedVideoLength}</span>
        </div>
    );
};

InfoDateLength.propTypes = propTypes;
