import React from 'react';
import PropTypes from 'prop-types';
import isFinite from 'lodash/isFinite';

const propTypes = {
    percentage: PropTypes.number.isRequired,
};

export const AutoplayProgressBar = ({
    percentage,
}) => {
    if (
        !isFinite(percentage) ||
        percentage < 0 ||
        percentage > 100
    ) {
        return null;
    }

    return (
        <div className="pl-card__progress-bar">
            <div
                className="pl-card__progress-bar--fill"
                style={{ width: `${percentage}%` }}
            />
        </div>
    );
};

AutoplayProgressBar.propTypes = propTypes;
