import React from 'react';
import PropTypes from 'prop-types';
import { PinnedVOD } from './pinned-vod';
import { OtherVODs } from './other-vods';
import classNames from 'classnames';

const FEATURE_VOD_INDEX = 0;
const TRACKING_OFFLINE_REC_TYPE = 'offline';
const TRACKING_POST_LIVE_REC_TYPE = 'postLive';

const propTypes = {
    videos: PropTypes.array.isRequired,
    i18n: PropTypes.object.isRequired,
    onSelectVOD: PropTypes.func.isRequired,
    playerHeight: PropTypes.number.isRequired,
    playerWidth: PropTypes.number.isRequired,
    onExit: PropTypes.func.isRequired,
    trackEvent: PropTypes.func.isRequired,
    windowObj: PropTypes.object.isRequired,
    streamWasOnline: PropTypes.bool.isRequired,
};

export class OfflineRecommendations extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            showFeatured: true,
        };

        this.handleCloseFeaturedPane = this.handleCloseFeaturedPane.bind(this);
    }

    componentWillMount() {
        const {
            trackEvent,
            streamWasOnline,
        } = this.props;

        const trackingRecType = streamWasOnline ? TRACKING_POST_LIVE_REC_TYPE : TRACKING_OFFLINE_REC_TYPE;

        trackEvent('player_rec_show', { type: trackingRecType });
    }

    render() {
        const {
            videos,
            i18n,
            windowObj,
            playerHeight,
            playerWidth,
            onSelectVOD,
            onExit,
            trackEvent,
        } = this.props;

        const {
            showFeatured,
        } = this.state;

        const otherVODsPaneComponent = (
            <OtherVODs
                height={playerHeight}
                width={playerWidth}
                videos={videos}
                onSelect={onSelectVOD}
                onClose={onExit}
                trackEvent={trackEvent}
                windowObj={windowObj}
                i18n={i18n}
            />
        );

        const featuredPaneComponent = (
            <PinnedVOD
                onClose={this.handleCloseFeaturedPane}
                onSelect={onSelectVOD}
                i18n={i18n}
                width={playerWidth}
                video={videos[FEATURE_VOD_INDEX]}
                trackEvent={trackEvent}
            />
        );

        const currentPaneComponent = showFeatured ? featuredPaneComponent : otherVODsPaneComponent;

        const RECOMMENDATION_CLASSES = classNames({
            'player-overlay': true,
            'recommendations-overlay': true,
            'pl-rec-wrapper': !this.state.showFeatured,
            'pl-single-rec-wrapper': this.state.showFeatured,
        });

        return (
            <div className={RECOMMENDATION_CLASSES}>
                {currentPaneComponent}
            </div>
        );
    }

    handleCloseFeaturedPane() {
        this.setState({
            showFeatured: false,
        });
    }
}

OfflineRecommendations.propTypes = propTypes;
