import PropTypes from 'prop-types';
import React from 'react';
import { AutoplayingPinnedVOD } from './autoplaying-pinned-vod';
import { OtherVODs } from './other-vods';
import classNames from 'classnames';

const FEATURE_VOD_INDEX = 0;
const TRACKING_POST_VOD_REC_TYPE = 'postVOD';

const RECOMMENDATION_CLASSES = classNames(
    'player-overlay',
    'recommendations-overlay',
    'pl-rec-wrapper'
);

const propTypes = {
    videos: PropTypes.array.isRequired,
    i18n: PropTypes.object.isRequired,
    onSelectVOD: PropTypes.func.isRequired,
    playerHeight: PropTypes.number.isRequired,
    playerWidth: PropTypes.number.isRequired,
    onExit: PropTypes.func.isRequired,
    trackEvent: PropTypes.func.isRequired,
    windowObj: PropTypes.object.isRequired,
    isMiniPlayer: PropTypes.bool.isRequired,
};

export class PostVODRecommendations extends React.Component {
    constructor(props) {
        super(...arguments);
        this.state = { showAutoplayingVOD: !props.isMiniPlayer };
        this.handleCancelAutoplayVOD = this.handleCancelAutoplayVOD.bind(this);
    }

    componentWillMount() {
        this.props.trackEvent('player_rec_show', { type: TRACKING_POST_VOD_REC_TYPE });
    }

    componentWillReceiveProps(nextProps) {
        if (this.state.showAutoplayingVOD && nextProps.isMiniPlayer) {
            this.setState({ showAutoplayingVOD: false });
        }
    }

    render() {
        const {
            videos,
            i18n,
            windowObj,
            playerHeight,
            playerWidth,
            onSelectVOD,
            onExit,
            trackEvent,
            isMiniPlayer,
        } = this.props;

        const { showAutoplayingVOD } = this.state;

        if (isMiniPlayer) {
            return null;
        }

        const otherVODsComponent = (
            <OtherVODs
                height={playerHeight}
                width={playerWidth}
                videos={videos}
                onSelect={onSelectVOD}
                onClose={onExit}
                trackEvent={trackEvent}
                windowObj={windowObj}
                i18n={i18n}
            />
        );

        const autoplayingVODComponent = (
            <AutoplayingPinnedVOD
                onClose={this.handleCancelAutoplayVOD}
                onSelect={onSelectVOD}
                i18n={i18n}
                width={playerWidth}
                video={videos[FEATURE_VOD_INDEX]}
                trackEvent={trackEvent}
                windowObj={windowObj}
            />
        );

        const currentViewComponent = showAutoplayingVOD ? autoplayingVODComponent : otherVODsComponent;

        return (
            <div className={RECOMMENDATION_CLASSES}>
                {currentViewComponent}
            </div>
        );
    }

    handleCancelAutoplayVOD() {
        this.setState({ showAutoplayingVOD: false });
    }
}

PostVODRecommendations.propTypes = propTypes;

