import isFinite from 'lodash/isFinite';
import React from 'react';
import PropTypes from 'prop-types';
import { getPercentage } from '../../../util/math';

const propTypes = {
    duration: PropTypes.number,
    mutedSegments: PropTypes.arrayOf(PropTypes.shape({
        duration: PropTypes.number,
        offset: PropTypes.number,
    })),
};

export const MutedSegments = ({ duration, mutedSegments }) => {
    if (!isFinite(duration) || duration <= 0) {
        return null;
    }

    if (!Array.isArray(mutedSegments) || mutedSegments.length <= 0) {
        return null;
    }

    const mutedSegmentComponents = mutedSegments.map(segment =>
        (
            <span
                className="player-slider__muted"
                style={{
                    width: `${getPercentage(segment.duration, duration)}%`,
                    left: `${getPercentage(segment.offset, duration)}%`,
                }}
                key={`${segment.offset}_${segment.duration}_${duration}`}
            />
        )
    );

    return (
        <div className="player-slider__muted-segments js-muted-segments-container">
            {mutedSegmentComponents}
        </div>
    );
};

MutedSegments.propTypes = propTypes;
