import React from 'react';
import PropTypes from 'prop-types';
import { getPercentage } from '../../../util/math';

const propTypes = {
    start: PropTypes.number.isRequired,
    end: PropTypes.number.isRequired,
    max: PropTypes.number.isRequired,
    min: PropTypes.number.isRequired,
};

export const SeekbarBuffer = ({ start, end, min, max }) => {
    const bufferLength = end - start;
    const totalDuration = max - min;
    return (
        <div
            style={{
                width: `${getPercentage(bufferLength, totalDuration)}%`,
                left: `${getPercentage(start, totalDuration)}%`,
            }}
            className="player-slider__buffer"
        />
    );
};

SeekbarBuffer.propTypes = propTypes;
