import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

export const ARROW_WIDTH = 20;

const propTypes = {
    popupLeftOffset: PropTypes.number,
    popupObject: PropTypes.object,
    popupWidth: PropTypes.number,
    seekbarWidth: PropTypes.number,
    hideThumbnailPreview: PropTypes.bool,
};

export const SeekbarPopup = ({ popupLeftOffset, popupObject, popupWidth, seekbarWidth, hideThumbnailPreview }) => {
    const PREVIEW_CONTAINER_CLASSES = classNames({
        'seekbar__popup--fadein': !hideThumbnailPreview,
        'seekbar__popup--fadeout': hideThumbnailPreview,
    });

    return (
        <div className={PREVIEW_CONTAINER_CLASSES}>
            <div
                className="player-slider__popup-container"
                style={{
                    width: popupObject.width,
                    left: getLeftOffset(popupLeftOffset, popupWidth, seekbarWidth),
                }}
            >
                <div
                    className="popup-thumb-wrapper"
                    style={{
                        width: popupObject.thumbOver.width,
                        height: popupObject.thumbOver.height,
                        maxHeight: popupObject.thumbOver.height,
                    }}
                >
                    <div
                        className="popup-marker-thumbunder"
                        style={{
                            height: popupObject.thumbUnder.height,
                            width: popupObject.thumbUnder.width,
                            backgroundSize: `${popupObject.thumbUnder.sheetWidth}px`,
                            backgroundImage: `url(${popupObject.thumbUnder.url})`,
                            backgroundPosition: `-${popupObject.thumbUnder.x}px -${popupObject.thumbUnder.y}px`,
                        }}
                    />
                    <div
                        className="popup-marker-thumbover"
                        style={{
                            height: popupObject.thumbOver.height,
                            width: popupObject.thumbOver.width,
                            backgroundSize: `${popupObject.thumbOver.sheetWidth}px`,
                            backgroundImage: `url(${popupObject.thumbOver.url})`,
                            backgroundPosition: `-${popupObject.thumbOver.x}px -${popupObject.thumbOver.y}px`,
                        }}
                    />
                </div>
                <div className="popup-info-wrapper">
                    <span className="popup-title">
                        {popupObject.title}
                    </span>
                    <span className="popup-info" dangerouslySetInnerHTML={{ __html: popupObject.info }} />
                </div>
                <span className="popup-timestamp">
                    {popupObject.timestamp}
                </span>
            </div>
            <div
                className="popup-arrow"
                style={{
                    left: getLeftOffset(popupLeftOffset, ARROW_WIDTH, seekbarWidth),
                }}
            />
        </div>
    );
};

/**
 * Used internally to calculate the the css 'left'
 * offset of the element based off the slider.
 *
 * @param {Float} The X pixel coordinate (offset of the left end of the seek slider)
 * @param {Float} The element's width
 * @param {Float} The seekbar's width
 */
function getLeftOffset(centerX, elementWidth, seekbarWidth) {
    const offset = centerX - (0.5 * elementWidth);
    const leftOffset = Math.max(0, Math.min(offset, seekbarWidth - elementWidth));

    return !isNaN(leftOffset) ? leftOffset : 0;
}

SeekbarPopup.propTypes = propTypes;
