import React from 'react';
import PropTypes from 'prop-types';
import * as Timestamp from '../../../util/timestamp';

const propTypes = {
    currentTime: PropTypes.number,
    duration: PropTypes.number,
};

export const SeekbarTimeDisplay = ({ currentTime, duration }) => {
    const formattedTime = Timestamp.toString(currentTime);
    const formattedTotalTime = Timestamp.toString(duration);
    return (
        <div className="player-seek__time-container">
            <span className="player-seek__time">{formattedTime}</span>
            <span className="player-seek__time player-seek__time--total">{formattedTotalTime}</span>
        </div>
    );
};

SeekbarTimeDisplay.propTypes = propTypes;
