import React from 'react';
import PropTypes from 'prop-types';
import * as Timestamp from '../../../util/timestamp';
import { SeekbarPopup } from './seekbar-popup';

const PREVIEW_POPUP_WIDTH = 148;

const propTypes = {
    hideThumbnailPreview: PropTypes.bool,
    duration: PropTypes.number,
    previews: PropTypes.object,
    mouseMoveClientX: PropTypes.number,
    seekbarLeftOffset: PropTypes.number,
    seekbarWidth: PropTypes.number,
};

const defaultProps = {
    duration: 0,
    seekbarLeftOffset: 0,
    seekbarWidth: 0,
};

export function ThumbnailPreviews({
    hideThumbnailPreview,
    duration,
    seekbarWidth,
    seekbarLeftOffset,
    previews,
    mouseMoveClientX,
}) {
    const popupLeftOffset = mouseMoveClientX - seekbarLeftOffset;
    const timestamp = duration * (popupLeftOffset / seekbarWidth);
    const popupObject = transformToPopupObject(
        previews,
        timestamp,
        duration
    );

    return (
        <SeekbarPopup
            popupLeftOffset={popupLeftOffset}
            popupObject={popupObject}
            popupWidth={PREVIEW_POPUP_WIDTH}
            seekbarWidth={seekbarWidth}
            hideThumbnailPreview={hideThumbnailPreview}
        />
    );
}

function transformToPopupObject(previews, timestamp, duration) {
    const thumbIndex = Math.floor(previews.count * (timestamp / duration)); // 0 indexed
    const hqSheetThumbIndex = thumbIndex % (previews.hq.cols * previews.hq.rows);
    const resizeFactor = PREVIEW_POPUP_WIDTH / previews.hq.width;

    return {
        thumbOver: {
            url: previews.hq.URLs[Math.floor(thumbIndex / (previews.hq.cols * previews.hq.rows))],
            height: previews.hq.height * resizeFactor,
            width: previews.hq.width * resizeFactor,
            sheetWidth: previews.hq.width * previews.hq.cols * resizeFactor,
            x: (hqSheetThumbIndex % previews.hq.cols) * previews.hq.width * resizeFactor,
            y: Math.floor(hqSheetThumbIndex / previews.hq.cols) * previews.hq.height * resizeFactor,
        },
        thumbUnder: {
            url: previews.lq.URLs[0],
            height: previews.hq.height * resizeFactor,
            width: previews.hq.width * resizeFactor,
            sheetWidth: previews.hq.width * previews.lq.cols * resizeFactor,
            x: (thumbIndex % previews.lq.cols) * previews.hq.width * resizeFactor,
            y: Math.floor(thumbIndex / previews.lq.cols) * previews.hq.height * resizeFactor,
        },
        title: '',
        info: '',
        timestamp: Timestamp.toString(timestamp, false),
        width: PREVIEW_POPUP_WIDTH,
    };
}

ThumbnailPreviews.propTypes = propTypes;
ThumbnailPreviews.defaultProps = defaultProps;
