import React from 'react';
import PropTypes from 'prop-types';
import * as Timestamp from '../../../util/timestamp';

const ARROW_WIDTH = 20;
const POPUP_WIDTH = 20;

const propTypes = {
    duration: PropTypes.number,
    mouseMoveClientX: PropTypes.number,
    seekbarLeftOffset: PropTypes.number,
    seekbarWidth: PropTypes.number,
    shouldCleanString: PropTypes.bool.isRequired,
};

const defaultProps = {
    duration: 0,
    seekbarLeftOffset: 0,
    seekbarWidth: 0,
};

export const TimestampPreview = ({
    duration,
    mouseMoveClientX,
    seekbarLeftOffset,
    seekbarWidth,
    shouldCleanString,
}) => {
    const popupLeftOffset = mouseMoveClientX - seekbarLeftOffset;
    const timestamp = duration * (popupLeftOffset / seekbarWidth);
    return (
        <div>
            <div
                className="player-slider__popup-container pl-flex--verticalCenter"
                style={{
                    left: getLeftOffset(popupLeftOffset, POPUP_WIDTH, seekbarWidth),
                    width: POPUP_WIDTH,
                }}
            >
                <span className="popup-timestamp-wrapper">
                    <span className="popup-timestamp">
                        {Timestamp.toString(timestamp, shouldCleanString)}
                    </span>
                </span>
            </div>
            <div
                className="popup-arrow"
                style={{
                    left: getLeftOffset(popupLeftOffset, ARROW_WIDTH, seekbarWidth),
                }}
            />
        </div>
    );
};

/**
 * Used internally to calculate the the css 'left'
 * offset of the element based off the slider.
 *
 * @param {Float} The X pixel coordinate (offset of the left end of the seek slider)
 * @param {Float} The element's width
 * @param {Float} The seekbar's width
 */
function getLeftOffset(centerX, elementWidth, seekbarWidth) {
    const offset = centerX - (0.5 * elementWidth);

    return Math.max(0, Math.min(offset, seekbarWidth - elementWidth));
}

TimestampPreview.propTypes = propTypes;
TimestampPreview.defaultProps = defaultProps;
