import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { translate } from 'react-i18next';
import { IDENTIFIER_MAIN_MENU } from './menu-manager';

const propTypes = {
    onMenuTransition: PropTypes.func,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    onMenuTransition() {},
};

export const HEADER_TEXT = 'Moderation';
export const DELETE_TEXT = 'Delete';
export const DELETE_ALL_TEXT = 'Delete All clips from Video';

const CLASSES_MENU_HEADER = classNames({
    'pl-menu__item': true,
    'pl-menu__item--block': true,
    'pl-menu__item--with-caret-left': true,
});

const CLASSES_SECTION_DIV = classNames({
    'pl-menu__section': true,
    'pl-menu__section--with-sep': true,
});

const CLASSES_BUTTON_DIV = classNames({
    'pl-menu__item': true,
    'pl-menu__item--block': true,
});

export class ClipsModerationMenuComponent extends React.Component {
    constructor() {
        super(...arguments);

        this.handleMenuTransition = this.handleMenuTransition.bind(this);
    }

    handleMenuTransition() {
        this.props.onMenuTransition(IDENTIFIER_MAIN_MENU);
    }

    render() {
        const { t } = this.props;

        return (
            <div className="pl-menu__inner">
                <div className={CLASSES_MENU_HEADER}>
                    <button
                        className="qa-header-button"
                        onClick={this.handleMenuTransition}
                    >
                        {t(HEADER_TEXT)}
                    </button>
                </div>
                <div className={CLASSES_SECTION_DIV}>
                    <div className={CLASSES_BUTTON_DIV}>
                        <button
                            className="qa-delete-button"
                            // onClick={} // TODO: hook up with postMessage
                        >
                            {t(DELETE_TEXT)}
                        </button>
                    </div>
                    <div className={CLASSES_BUTTON_DIV}>
                        <button
                            className="qa-delete-all-button"
                            // onClick={} // TODO: hook up with postMessage
                        >
                            {t(DELETE_ALL_TEXT)}
                        </button>
                    </div>
                </div>
            </div>
        );
    }
}

ClipsModerationMenuComponent.propTypes = propTypes;
ClipsModerationMenuComponent.defaultProps = defaultProps;

export const ClipsModerationMenu = translate()(ClipsModerationMenuComponent);
