import React from 'react';
import PropTypes from 'prop-types';
import { Button } from 'ui/components/buttons/base-button';
import classNames from 'classnames';

const propTypes = {
    isActive: PropTypes.bool.isRequired,
    label: PropTypes.string.isRequired,
    onClick: PropTypes.func,
    speedValue: PropTypes.number.isRequired,
};

const defaultProps = {
    onClick() {},
};

export class PlaybackSpeedButton extends React.Component {
    constructor() {
        super(...arguments);

        this.handleClick = this.handleClick.bind(this);
    }

    handleClick() {
        this.props.onClick(this.props.speedValue);
    }

    render() {
        const { isActive, label } = this.props;
        const classes = classNames({
            'pl-menu__item': true,
            'pl-menu__item--block': true,
            'pl-menu__item--active': isActive,
        });

        return (
            <div className={classes}>
                <Button
                    className="ellipsis"
                    onClick={this.handleClick}
                >
                    <span>{label}</span>
                </Button>
            </div>
        );
    }
}

PlaybackSpeedButton.propTypes = propTypes;
PlaybackSpeedButton.defaultProps = defaultProps;
