import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Button } from '../buttons/base-button';

const propTypes = {
    isActive: PropTypes.bool,
    qualityObj: PropTypes.shape({
        name: PropTypes.string,
    }).isRequired,
    onQualitySelect: PropTypes.func,
};

const defaultProps = {
    isActive: false,
    onQualitySelect() {},
};

const QUALITY_BUTTON_CLASSES = classNames({
    ellipsis: true,
    'pl-quality-option-button': true,
});

export class QualityButton extends React.Component {
    constructor() {
        super(...arguments);

        this.handleSelectQuality = this.handleSelectQuality.bind(this);
    }

    handleSelectQuality() {
        this.props.onQualitySelect(this.props.qualityObj);
    }

    render() {
        const { isActive, qualityObj } = this.props;
        const classes = classNames({
            'pl-menu__item': true,
            'pl-menu__item--block': true,
            'pl-menu__item--active': isActive,
        });

        return (
            <div className={classes} >
                <Button
                    className={QUALITY_BUTTON_CLASSES}
                    onClick={this.handleSelectQuality}
                >
                    <span>{qualityObj.name}</span>
                </Button>
            </div>
        );
    }
}

QualityButton.propTypes = propTypes;
QualityButton.defaultProps = defaultProps;
