import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { translate } from 'react-i18next';
import { IDENTIFIER_MAIN_MENU } from './menu-manager';
import { QualityButton } from './quality-button';

const propTypes = {
    availableQualities: PropTypes.arrayOf(PropTypes.shape({
        group: PropTypes.string,
    })).isRequired,
    selectedQuality: PropTypes.string.isRequired,
    onMenuTransition: PropTypes.func,
    onQualitySelect: PropTypes.func,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    onMenuTransition() {},
    onQualitySelect() {},
};

export const CLASSES_MENU_HEADER = classNames({
    'pl-menu__item': true,
    'pl-menu__item--block': true,
    'pl-menu__item--with-caret-left': true,
});

const CLASSES_SECTION_DIV = classNames({
    'pl-menu__section': true,
    'pl-menu__section--with-sep': true,
});

export class QualityMenuComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.handleMenuTransition = this.handleMenuTransition.bind(this);
    }

    handleMenuTransition() {
        this.props.onMenuTransition(IDENTIFIER_MAIN_MENU);
    }

    render() {
        const { t } = this.props;
        const qualityItems = this._getQualityItems();
        return (
            <div className="pl-menu__inner">
                <div className={CLASSES_MENU_HEADER}>
                    <button
                        className="qa-header-button"
                        onClick={this.handleMenuTransition}
                    >
                        {t('Video Quality')}
                    </button>
                </div>
                <div className={CLASSES_SECTION_DIV}>
                    {qualityItems}
                </div>
            </div>
        );
    }

    _getQualityItems() {
        const { selectedQuality, onQualitySelect } = this.props;

        return this.props.availableQualities.map(qualityObj => {
            const isActive = qualityObj.group === selectedQuality;
            return (
                <QualityButton
                    isActive={isActive}
                    key={qualityObj.group}
                    onQualitySelect={onQualitySelect}
                    qualityObj={qualityObj}
                />
            );
        });
    }
}

QualityMenuComponent.propTypes = propTypes;
QualityMenuComponent.defaultProps = defaultProps;

export const QualityMenu = translate()(QualityMenuComponent);
