import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

const propTypes = {
    bannerLabel: PropTypes.string.isRequired,
    showBanner: PropTypes.bool.isRequired,
};

const CLASSES_DIV_CONTAINER = classNames({
    'pl-settings-container': true,
    'pl-flex': true,
    'pl-flex--verticalCenter': true,
});

export const SettingsBanner = ({ bannerLabel, showBanner }) => {
    const spanClasses = classNames({
        'pl-pill': true,
        'pl-settings-banner--animateIn': showBanner,
        'pl-settings-banner--animateOut': !showBanner,
        'qa-settings-banner-span': true,
    });
    return (
        <div className={CLASSES_DIV_CONTAINER}>
            <span className={spanClasses}>
                {bannerLabel}
            </span>
        </div>
    );
};

SettingsBanner.propTypes = propTypes;
