import React from 'react';
import PropTypes from 'prop-types';
import { Button } from '../buttons/base-button';
import { Icon } from '../buttons/base-icon';
import classNames from 'classnames';

const propTypes = {
    onClick: PropTypes.func,
    showSpinningAnimation: PropTypes.bool.isRequired,
};

const defaultProps = {
    onClick() {},
};

export const SettingsButton = ({ onClick, showSpinningAnimation }) => {
    const settingsButtonClasses = classNames({
        'qa-settings-button': true,
        'player-button--settings': true,
        'player-button': true,
    });
    const settingsButtonIconClasses = classNames({
        'pl-settings-icon': true,
        'pl-settings-icon--spin': showSpinningAnimation,
    });

    return (
        <Button
            onClick={onClick}
            className={settingsButtonClasses}
        >
            <Icon
                label="Settings"
                iconId="#icon_settings"
                iconClass={settingsButtonIconClasses}
            />
        </Button>
    );
};

SettingsButton.propTypes = propTypes;
SettingsButton.defaultProps = defaultProps;
