import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { translate } from 'react-i18next';
import { IDENTIFIER_MAIN_MENU } from './menu-manager';
import { Button } from 'ui/components/buttons/base-button';

const propTypes = {
    onMenuTransition: PropTypes.func,
    onRunLocalPrerollAd: PropTypes.func,
    onRunLocalMidrollAd: PropTypes.func,
    onRunLocalPostrollAd: PropTypes.func,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    onRunLocalPrerollAd() {},
    onRunLocalMidrollAd() {},
    onRunLocalPostrollAd() {},
    onMenuTransition() {},
};

export const CLASSES_MENU_HEADER = classNames({
    'pl-menu__item': true,
    'pl-menu__item--block': true,
    'pl-menu__item--with-caret-left': true,
});

const CLASSES_SECTION_DIV = classNames({
    'pl-menu__section': true,
    'pl-menu__section--with-sep': true,
});

const CLASSES_SECTION_BUTTON = classNames({
    'pl-menu__item': true,
    'pl-menu__item--block': true,
});

export class StaffMenuComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.handleMenuTransition = this.handleMenuTransition.bind(this);
    }

    handleMenuTransition() {
        this.props.onMenuTransition(IDENTIFIER_MAIN_MENU);
    }

    render() {
        const { t } = this.props;
        const runLocalAdButtons = this._renderLocalAdButtons();
        return (
            <div className="pl-menu__inner">
                <div className={CLASSES_MENU_HEADER}>
                    <Button
                        className="qa-header-button"
                        onClick={this.handleMenuTransition}
                    >
                        {t('Staff')}
                    </Button>
                </div>
                <div className={CLASSES_SECTION_DIV}>
                    {runLocalAdButtons}
                </div>
            </div>
        );
    }

    _renderLocalAdButtons() {
        const {
            onRunLocalPrerollAd,
            onRunLocalMidrollAd,
            onRunLocalPostrollAd,
        } = this.props;

        const localPrerollButton = (
            <div className={CLASSES_SECTION_BUTTON}>
                <Button
                    className="ellipsis"
                    onClick={onRunLocalPrerollAd}
                >
                    <span>Run Local Preroll Ad</span>
                </Button>
            </div>
        );

        const localMidrollButton = (
            <div className={CLASSES_SECTION_BUTTON}>
                <Button
                    className="ellipsis"
                    onClick={onRunLocalMidrollAd}
                >
                    <span>Run Local Midroll Ad</span>
                </Button>
            </div>
        );

        const localPostrollButton = (
            <div className={CLASSES_SECTION_BUTTON}>
                <Button
                    className="ellipsis"
                    onClick={onRunLocalPostrollAd}
                >
                    <span>Run Local Postroll Ad</span>
                </Button>
            </div>
        );

        return (
            <div>
                {localPrerollButton}
                {localMidrollButton}
                {localPostrollButton}
            </div>
        );
    }
}

StaffMenuComponent.propTypes = propTypes;
StaffMenuComponent.defaultProps = defaultProps;

export const StaffMenu = translate()(StaffMenuComponent);
