import React from 'react';
import PropTypes from 'prop-types';
import { getPercentage } from '../../../util/math';

const propTypes = {
    className: PropTypes.string,
    max: PropTypes.number.isRequired,
    min: PropTypes.number.isRequired,
    value: PropTypes.number.isRequired,
};

const defaultProps = {
    className: '',
};

export const SliderLeft = ({
    className,
    max,
    min,
    value,
}) => {
    const currentSliderValue = value - min;
    const totalSliderValue = max - min;
    const widthStyle = `${getPercentage(currentSliderValue, totalSliderValue)}%`;

    return (
        <div
            style={{ width: widthStyle }}
            className={className}
        />
    );
};

SliderLeft.propTypes = propTypes;
SliderLeft.defaultProps = defaultProps;
