import React from 'react';
import PropTypes from 'prop-types';
import { getPercentage } from '../../../util/math';

const propTypes = {
    className: PropTypes.string,
    max: PropTypes.number.isRequired,
    min: PropTypes.number.isRequired,
    value: PropTypes.number.isRequired,
};

const defaultProps = {
    className: '',
};

export const SliderThumb = ({
    className,
    max,
    min,
    value,
}) => {
    const currentSliderValue = value - min;
    const totalSliderValue = max - min;
    const leftStyle = `${getPercentage(currentSliderValue, totalSliderValue)}%`;

    return (
        <div
            style={{ left: leftStyle }}
            className={className}
        />
    );
};

SliderThumb.propTypes = propTypes;
SliderThumb.defaultProps = defaultProps;
