import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const propTypes = {
    statName: PropTypes.string.isRequired,
    value: PropTypes.oneOfType([
        PropTypes.string,
        PropTypes.number,
    ]).isRequired,
    t: PropTypes.func.isRequired,
};

export function StatComponent({ statName, value, t }) {
    return (
        <li
            className="pl-playback-stats--stat"
        >
            {`${t(statName)}: `}
            <div>
                <span>{value}</span>
            </div>
        </li>
    );
}

StatComponent.propTypes = propTypes;
export const Stat = translate()(StatComponent);
