import PropTypes from 'prop-types';
import React from 'react';
import { twitchHost } from 'settings';

export const WATCH_PARTY_CLASSES = {
    container: 'player-streaminfo__watchparty',
    divider: 'player-streaminfo__watchparty-divider',
};

export const WatchPartyDetails = props => {
    const isViewable = props.isViewable;
    const vodId = props.vodId;
    const vodTitle = props.vodTitle;

    if (!vodId || vodId.length === 0) {
        return null;
    }

    if (isViewable) {
        return (
            <span>
                :&nbsp;
                <a href={`${twitchHost}/videos/${vodId}`} target="_blank">
                    {vodTitle}
                </a>
            </span>
        );
    }

    return (
        <span>
            :&nbsp;
            {vodTitle}
        </span>
    );
};

WatchPartyDetails.propTypes = {
    vodId: PropTypes.string,
    vodTitle: PropTypes.string,
    isViewable: PropTypes.bool,
};

