import PropTypes from 'prop-types';
import React from 'react';
import { translate } from 'react-i18next';
import { WatchPartyDetails } from './watch-party-details';

export const WATCH_PARTY_CLASSES = {
    container: 'player-streaminfo__watchparty',
    divider: 'player-streaminfo__watchparty-divider',
};

// To allow this many cases in a switch, disabling complexity check
/* eslint-disable complexity */
function broadcastTypeToTitle(broadcastType) {
    switch (broadcastType) {
    case 'highlight':
        return 'Playing highlight';
    case 'archive':
        return 'Playing past broadcast';
    case 'upload':
        return 'Playing uploaded video';
    case 'rerun':
        return 'Rerun of video';
    case 'premiere':
        return 'Premiering video';
    default:
        return 'Playing pre-recorded video';
    }
}

export const WatchPartyStreamInfoComponent = props => {
    const isViewable = props.vodIsViewable;
    const t = props.t;
    const vodId = props.vodId;
    const vodTitle = props.vodTitle;
    const vodBroadcastType = props.vodBroadcastType;

    return (
        <div className={WATCH_PARTY_CLASSES.container}>
            {t(broadcastTypeToTitle(vodBroadcastType))}
            <WatchPartyDetails
                vodId={vodId}
                vodTitle={vodTitle}
                isViewable={isViewable}
            />
            <div className={WATCH_PARTY_CLASSES.divider} />
        </div>
    );
};

WatchPartyStreamInfoComponent.propTypes = {
    t: PropTypes.func,
    vodId: PropTypes.string,
    vodTitle: PropTypes.string,
    vodIsViewable: PropTypes.bool,
    vodBroadcastType: PropTypes.string,
};

export const WatchPartyStreamInfo = translate()(WatchPartyStreamInfoComponent);
