import React from 'react';
import PropTypes from 'prop-types';
import { BottomLeftControls } from 'ui/components/bottom-controls/bottom-left-controls';
import { BottomRightControls } from 'ui/components/bottom-controls/bottom-right-controls';
import { Seekbar } from 'ui/containers/seekbar';
import classNames from 'classnames';
import { connect } from 'react-redux';
import { SIDEBAR_VIEW } from 'state/collection';

const propTypes = {
    getCurrentTime: PropTypes.func.isRequired,
    showBottomControls: PropTypes.bool.isRequired,
};

export const CONTAINER_CLASSES = classNames(
    'pl-controls-bottom',
    'pl-flex',
    'qa-controls-bottom'
);

export const mapStateToProps = ({ collection }) => ({
    showBottomControls: collection.currentView !== SIDEBAR_VIEW,
});

// NOTE: we need getCurrentTime function to be passed for performance reasons,
// to avoid storing currentTime and updating all of Redux in order to update the seekbar at 60fps
export const BottomControlsContainer = ({ getCurrentTime, showBottomControls }) => {
    if (!showBottomControls) {
        return null;
    }

    return (
        <div className={CONTAINER_CLASSES}>
            <Seekbar getCurrentTime={getCurrentTime} />
            <BottomLeftControls />
            <BottomRightControls />
        </div>
    );
};

BottomControlsContainer.propTypes = propTypes;

export const BottomControls = connect(mapStateToProps)(BottomControlsContainer);
