import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { startCast, stopCast } from 'actions/chromecast';
import { AVAILABLE, CONNECTED } from 'state/chromecast';
import { PLAYER_HIGHLIGHTER } from 'util/player-type';
import {
    ChromecastButton as ChromecastButtonComponent,
} from 'ui/components/buttons/chromecast-button';

const propTypes = {
    castingState: PropTypes.string.isRequired,
    playerType: PropTypes.string.isRequired,
    startCast: PropTypes.func,
    stopCast: PropTypes.func,
};

const defaultProps = {
    startCast() {},
    stopCast() {},
};

const mapStateToProps = ({ chromecast, env }) => ({
    castingState: chromecast.castingState,
    playerType: env.playerType,
});

const mapDispatchToProps = dispatch => ({
    startCast() {
        dispatch(startCast());
    },
    stopCast() {
        dispatch(stopCast());
    },
});

export function ChromecastButtonContainer({ castingState, playerType, stopCast, startCast }) {
    if (playerType === PLAYER_HIGHLIGHTER) {
        return null;
    }

    let onClick;

    if (castingState === AVAILABLE) {
        onClick = startCast;
    } else if (castingState === CONNECTED) {
        onClick = stopCast;
    } else {
        onClick = () => {};
    }

    return (
        <ChromecastButtonComponent
            castingState={castingState}
            onClick={onClick}
        />
    );
}

ChromecastButtonContainer.propTypes = propTypes;
ChromecastButtonContainer.defaultProps = defaultProps;
export const ChromecastButton = connect(mapStateToProps, mapDispatchToProps)(ChromecastButtonContainer);
