import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { ClipsButton as ClipsButtonComponent } from 'ui/components/buttons/clips-button';
import { PLAYER_SITE } from 'util/player-type';
import { trackEvent } from 'actions/analytics-tracker';
import { userCanClipSelector } from 'state/clips';

const propTypes = {
    clipGenerator: PropTypes.shape({
        recordClip: PropTypes.func.isRequired,
    }).isRequired,
    userCanClip: PropTypes.bool.isRequired,
    isSitePlayer: PropTypes.bool.isRequired,
    trackClipRecord: PropTypes.func.isRequired,
};

export const mapStateToProps = state => ({
    clipGenerator: state.clips.generator,
    isSitePlayer: state.env.playerType === PLAYER_SITE,
    userCanClip: userCanClipSelector(state),
});

export const mapDispatchToProps = dispatch => ({
    trackClipRecord() {
        dispatch(trackEvent('player_click_clip'));
    },
});

export class ClipsButtonContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.onClip = this.onClip.bind(this);
    }

    onClip() {
        this.props.clipGenerator.recordClip();
        this.props.trackClipRecord();
    }

    render() {
        const { isSitePlayer, userCanClip } = this.props;

        if (!userCanClip) {
            return null;
        }

        return (
            <ClipsButtonComponent
                onClip={this.onClip}
                hasAltShortcut={isSitePlayer}
            />
        );
    }
}

ClipsButtonContainer.propTypes = propTypes;

export const ClipsButton = connect(mapStateToProps, mapDispatchToProps)(ClipsButtonContainer);
