import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { setCaptionsEnabled } from 'actions/captions';
import { trackEvent } from 'actions/analytics-tracker';
import { ClosedCaptionButton as ClosedCaptionButtonComponent } from 'ui/components/buttons/closed-caption-button';

const propTypes = {
    captionsAvailable: PropTypes.bool.isRequired,
    captionsEnabled: PropTypes.bool.isRequired,
    onEnableCaptions: PropTypes.func.isRequired,
    onDisableCaptions: PropTypes.func.isRequired,
};

const mapStateToProps = ({ captions }) => ({
    captionsAvailable: captions.available,
    captionsEnabled: captions.enabled,
});

export const mapDispatchToProps = dispatch => ({
    onEnableCaptions() {
        dispatch(setCaptionsEnabled(true));
        dispatch(trackEvent('player_click_cc'));
    },

    onDisableCaptions() {
        dispatch(setCaptionsEnabled(false));
        dispatch(trackEvent('player_click_cc'));
    },
});

export function ClosedCaptionButtonContainer({
    captionsAvailable,
    captionsEnabled,
    onEnableCaptions,
    onDisableCaptions,
}) {
    if (!captionsAvailable) {
        return null;
    }

    return (
        <ClosedCaptionButtonComponent
            captionsEnabled={captionsEnabled}
            onEnableCaptions={onEnableCaptions}
            onDisableCaptions={onDisableCaptions}
        />
    );
}

ClosedCaptionButtonContainer.propTypes = propTypes;

export const ClosedCaptionButton = connect(mapStateToProps, mapDispatchToProps)(ClosedCaptionButtonContainer);
