import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { FullScreenButton as FullScreenButtonComponent } from 'ui/components/buttons/fullscreen-button';
import { setFullScreen } from 'actions/screen-mode';
import { trackEvent } from 'actions/analytics-tracker';

const propTypes = {
    canFullScreen: PropTypes.bool.isRequired,
    hasBranding: PropTypes.bool.isRequired,
    isFullScreen: PropTypes.bool.isRequired,
    onFullScreen: PropTypes.func.isRequired,
    onUnFullScreen: PropTypes.func.isRequired,
};

export const mapStateToProps = ({ screenMode, playerOptions }) => ({
    canFullScreen: screenMode.canFullScreen,
    hasBranding: playerOptions.branding,
    isFullScreen: screenMode.isFullScreen,
});

export const mapDispatchToProps = dispatch => ({
    onFullScreen() {
        dispatch(setFullScreen(true));
        dispatch(trackEvent('player_click_fullscreen'));
    },

    onUnFullScreen() {
        dispatch(setFullScreen(false));
        dispatch(trackEvent('player_click_fullscreen'));
    },
});

export function FullScreenButtonContainer({
    canFullScreen,
    hasBranding,
    isFullScreen,
    onFullScreen,
    onUnFullScreen,
}) {
    return (
        <FullScreenButtonComponent
            canFullScreen={canFullScreen}
            hasBranding={hasBranding}
            isFullScreen={isFullScreen}
            onFullScreen={onFullScreen}
            onUnFullScreen={onUnFullScreen}
        />
    );
}

FullScreenButtonContainer.propTypes = propTypes;

export const FullScreenButton = connect(mapStateToProps, mapDispatchToProps)(FullScreenButtonContainer);
