import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { Button } from 'ui/components/buttons/base-button';
import classNames from 'classnames';
import { translate } from 'react-i18next';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    isOwnChannel: PropTypes.bool.isRequired,
    isSubscribed: PropTypes.bool.isRequired,
    isSubscribable: PropTypes.bool.isRequired,
    onSubscribe: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

export const mapStateToProps = state => ({
    channelName: state.streamMetadata.channel.name,
    isOwnChannel: state.streamMetadata.channel.id === state.user.id,
    isSubscribed: state.subscriptions.isSubscribed,
    isSubscribable: state.subscriptions.isSubscribable,
});

export function SubscribeButtonComponent(props) {
    if (!props.isSubscribable || props.isOwnChannel) {
        return null;
    }

    const className = classNames({
        'pl-button': true,
        'pl-button--subscribe': true,
        'pl-button--success': props.isSubscribed,
    });

    let message;
    let mobileMessage;

    if (props.isSubscribed) {
        message = props.t('Subscribed');
        mobileMessage = message;
    } else {
        message = props.t('Subscribe to {{channelName}}', { channelName: props.channelName });
        mobileMessage = props.t('Subscribe');
    }

    return (
        <Button className={className} onClick={props.onSubscribe}>
            <span className="pl-button__text pl-button__text--desktop">{message}</span>
            <span className="pl-button__text pl-button__text--mobile">{mobileMessage}</span>
        </Button>
    );
}

SubscribeButtonComponent.propTypes = propTypes;

const withStoreProps = connect(mapStateToProps);
export const SubscribeButton = translate()(withStoreProps(SubscribeButtonComponent));
