import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { TheatreModeButton as TheatreModeButtonComponent } from 'ui/components/buttons/theatre-mode-button';
import { setTheatreMode } from 'actions/screen-mode';
import { trackEvent } from 'actions/analytics-tracker';

const propTypes = {
    canTheatreMode: PropTypes.bool.isRequired,
    disableTheatreMode: PropTypes.func.isRequired,
    enableTheatreMode: PropTypes.func.isRequired,
    isFullScreen: PropTypes.bool.isRequired,
    isTheatreMode: PropTypes.bool.isRequired,
};

const mapStateToProps = ({ screenMode }) => ({
    canTheatreMode: screenMode.canTheatreMode,
    isFullScreen: screenMode.isFullScreen,
    isTheatreMode: screenMode.isTheatreMode,
});

export const mapDispatchToProps = dispatch => ({
    enableTheatreMode() {
        dispatch(setTheatreMode(true));
        dispatch(trackEvent('player_click_theater'));
    },

    disableTheatreMode() {
        dispatch(setTheatreMode(false));
        dispatch(trackEvent('player_click_theater'));
    },
});

export function TheatreModeButtonContainer({
    canTheatreMode,
    isTheatreMode,
    enableTheatreMode,
    disableTheatreMode,
    isFullScreen,
}) {
    return canTheatreMode && !isFullScreen ? (
        <TheatreModeButtonComponent
            theatreModeEnabled={isTheatreMode}
            turnOn={enableTheatreMode}
            turnOff={disableTheatreMode}
        />
    ) : null;
}

TheatreModeButtonContainer.propTypes = propTypes;

export const TheatreModeButton = connect(mapStateToProps, mapDispatchToProps)(TheatreModeButtonContainer);
