import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { setCaptionsPreset } from 'actions/captions';
import { BGandWindowPanel as BGandWindowPanelComponent } from 'ui/components/closed-captions/bg-and-window-panel';

export const BACKGROUND = 'Background';
const CUSTOM_PRESET = 'custom';

const propTypes = {
    selectColor: PropTypes.func.isRequired,
    selectOpacity: PropTypes.func.isRequired,
    currentColor: PropTypes.string.isRequired,
    currentOpacity: PropTypes.string.isRequired,
};

export const mapStateToProps = ({ captions }) => ({
    currentColor: captions.style.backgroundColorName,
    currentOpacity: captions.style.backgroundOpacity,
});

export const mapDispatchToProps = dispatch => ({
    selectColor(backgroundColorName) {
        dispatch(setCaptionsPreset(CUSTOM_PRESET, {
            backgroundColorName,
        }));
    },
    selectOpacity(backgroundOpacity) {
        dispatch(setCaptionsPreset(CUSTOM_PRESET, {
            backgroundOpacity,
        }));
    },
});

export function BackgroundPanelContainer({
    currentColor,
    selectColor,
    selectOpacity,
    currentOpacity,
}) {
    return (
        <BGandWindowPanelComponent
            currentColor={currentColor}
            currentOpacity={currentOpacity}
            selectColor={selectColor}
            selectOpacity={selectOpacity}
        />
    );
}

BackgroundPanelContainer.propTypes = propTypes;

export const BackgroundPanel = connect(mapStateToProps, mapDispatchToProps)(BackgroundPanelContainer);
