import React from 'react';
import enhanceWithClickOutside from 'react-click-outside';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import {
    ClosedCaptionsPanel as ClosedCaptionsPanelComponent,
} from 'ui/components/closed-captions/closed-captions-panel';
import { showCCModal } from 'actions/captions';

const propTypes = {
    onClose: PropTypes.func.isRequired,
    showPanel: PropTypes.bool.isRequired,
};

export const mapStateToProps = ({ captions }) => ({
    showPanel: captions.showCCModal,
});

export const mapDispatchToProps = dispatch => ({
    onClose() {
        dispatch(showCCModal(false));
    },
});

export class ClosedCaptionsPanelContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.handleClickOutside = this.handleClickOutside.bind(this);
    }

    handleClickOutside() {
        const { onClose, showPanel } = this.props;
        if (showPanel) {
            onClose();
        }
    }

    render() {
        const { onClose, showPanel } = this.props;
        if (!showPanel) {
            return null;
        }

        return (
            <ClosedCaptionsPanelComponent
                onClose={onClose}
            />
        );
    }
}

ClosedCaptionsPanelContainer.propTypes = propTypes;

export const ClosedCaptionsPanel = connect(
    mapStateToProps,
    mapDispatchToProps
)(enhanceWithClickOutside(ClosedCaptionsPanelContainer));
