import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import {
    EffectsPanel as EffectsPanelComponent,
} from 'ui/components/closed-captions/effects-panel';
import { setCaptionsPreset, CUSTOM } from 'actions/captions';

export const EFFECTS = 'Effects';

const propTypes = {
    boldText: PropTypes.bool.isRequired,
    italicText: PropTypes.bool.isRequired,
    underlineText: PropTypes.bool.isRequired,
    currentTextEffect: PropTypes.string.isRequired,
    selectTextEffect: PropTypes.func.isRequired,
    selectTextStyle: PropTypes.func.isRequired,
};

export const mapStateToProps = ({ captions }) => ({
    boldText: captions.style.fontBold === 'bold',
    italicText: captions.style.fontItalic === 'italic',
    underlineText: captions.style.fontUnderline === 'underline',
    currentTextEffect: captions.style.edge,
});

export const mapDispatchToProps = dispatch => ({
    selectTextEffect(effect) {
        dispatch(setCaptionsPreset(CUSTOM, {
            edge: effect,
        }));
    },
    selectTextStyle(fontProperty, fontValue) {
        dispatch(setCaptionsPreset(CUSTOM, {
            [fontProperty]: fontValue,
        }));
    },
});

export function EffectsPanelContainer({
    boldText,
    italicText,
    underlineText,
    currentTextEffect,
    selectTextEffect,
    selectTextStyle,
}) {
    return (
        <EffectsPanelComponent
            boldText={boldText}
            italicText={italicText}
            underlineText={underlineText}
            currentTextEffect={currentTextEffect}
            selectTextStyle={selectTextStyle}
            selectTextEffect={selectTextEffect}
        />
    );
}

EffectsPanelContainer.propTypes = propTypes;

export const EffectsPanel = connect(mapStateToProps, mapDispatchToProps)(EffectsPanelContainer);
