import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { PresetsPanel as PresetsPanelComponent } from 'ui/components/closed-captions/presets-panel';
import * as StyleMap from 'captions/captions-style-map';
import { setCaptionsPreset } from 'actions/captions';

export const PRESETS = 'Presets';

const propTypes = {
    onSelect: PropTypes.func.isRequired,
    selectedValue: PropTypes.string.isRequired,
};

export const mapStateToProps = ({ captions }) => ({
    selectedValue: captions.preset,
});

export const mapDispatchToProps = dispatch => ({
    onSelect(presetValue) {
        dispatch(setCaptionsPreset(
            presetValue,
            StyleMap.presetMap[presetValue]
        ));
    },
});

export function PresetsPanelContainer({ onSelect, selectedValue }) {
    return (
        <PresetsPanelComponent
            onSelect={onSelect}
            selectedValue={selectedValue}
        />
    );
}

PresetsPanelContainer.propTypes = propTypes;

export const PresetsPanel = connect(mapStateToProps, mapDispatchToProps)(PresetsPanelContainer);
