import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { TextPanel as TextPanelComponent } from 'ui/components/closed-captions/text-panel';
import { setCaptionsPreset, CUSTOM } from 'actions/captions';

const propTypes = {
    currentAlignment: PropTypes.string.isRequired,
    currentColor: PropTypes.string.isRequired,
    currentFont: PropTypes.string.isRequired,
    currentFontSize: PropTypes.number.isRequired,
    currentPosition: PropTypes.string.isRequired,
    currentOpacity: PropTypes.string.isRequired,
    selectFontChange: PropTypes.func.isRequired,
};

export const TEXT = 'Text';

export const mapStateToProps = ({ captions }) => ({
    currentAlignment: captions.style.alignment,
    currentColor: captions.style.fontColorName,
    currentFont: captions.style.font,
    currentFontSize: captions.style.fontSize,
    currentPosition: captions.style.verticalPosition,
    currentOpacity: captions.style.fontOpacity,
});

export const mapDispatchToProps = dispatch => ({
    selectFontChange(fontProp, changeValue) {
        dispatch(setCaptionsPreset(CUSTOM, {
            [fontProp]: changeValue,
        }));
    },
});

export function TextPanelContainer({
    currentAlignment,
    currentColor,
    currentFont,
    currentFontSize,
    currentPosition,
    currentOpacity,
    selectFontChange,
}) {
    return (
        <TextPanelComponent
            currentAlignment={currentAlignment}
            currentColor={currentColor}
            currentFont={currentFont}
            currentFontSize={currentFontSize}
            currentPosition={currentPosition}
            currentOpacity={currentOpacity}
            selectFontChange={selectFontChange}
        />
    );
}

TextPanelContainer.propTypes = propTypes;

export const TextPanel = connect(mapStateToProps, mapDispatchToProps)(TextPanelContainer);
