import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { setCaptionsPreset } from 'actions/captions';
import { BGandWindowPanel as  BGandWindowPanelComponent } from 'ui/components/closed-captions/bg-and-window-panel';

export const WINDOW = 'Window';
const CUSTOM_PRESET = 'custom';

const propTypes = {
    selectColor: PropTypes.func.isRequired,
    selectOpacity: PropTypes.func.isRequired,
    currentColor: PropTypes.string.isRequired,
    currentOpacity: PropTypes.string.isRequired,
};

export const mapStateToProps = ({ captions }) => ({
    currentColor: captions.style.windowColorName,
    currentOpacity: captions.style.windowOpacity,
});

export const mapDispatchToProps = dispatch => ({
    selectColor(windowColorName) {
        dispatch(setCaptionsPreset(CUSTOM_PRESET, {
            windowColorName,
        }));
    },
    selectOpacity(windowOpacity) {
        dispatch(setCaptionsPreset(CUSTOM_PRESET, {
            windowOpacity,
        }));
    },
});

export function WindowPanelContainer({
    currentColor,
    selectColor,
    selectOpacity,
    currentOpacity,
}) {
    return (
        <BGandWindowPanelComponent
            currentColor={currentColor}
            currentOpacity={currentOpacity}
            selectColor={selectColor}
            selectOpacity={selectOpacity}
        />
    );
}

WindowPanelContainer.propTypes = propTypes;

export const WindowPanel = connect(mapStateToProps, mapDispatchToProps)(WindowPanelContainer);
