import PropTypes from 'prop-types';
import React from 'react';
import { connect } from 'react-redux';
import { COLLECTION_EMPTY_SCREEN } from 'actions/screen';
import {
    CollectionEmptyOverlay as CollectionEmptyOverlayComponent,
} from 'ui/components/collections/collection-empty-overlay';

const propTypes = {
    shouldShow: PropTypes.bool.isRequired,
};

export const mapStateToProps = ({ screen, ui }) => ({
    shouldShow: screen[0] === COLLECTION_EMPTY_SCREEN && !ui.isMini,
});

export const CollectionEmptyOverlayContainer = ({ shouldShow }) => {
    if (!shouldShow) {
        return null;
    }

    return <CollectionEmptyOverlayComponent />;
};

CollectionEmptyOverlayContainer.propTypes = propTypes;

export const CollectionEmptyOverlay = connect(mapStateToProps)(CollectionEmptyOverlayContainer);
