import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

/**
 * Usage:
 *   const EXP_UUID = 'experiment uuid';
 *
 *   <Experiment
 *     uuid={EXP_UUID}
 *     renderValue={'group-a'}
 *   >
 *     <FollowPanel />
 *   </Experiment>
 */

const propTypes = {
    uuid: PropTypes.string.isRequired,
    renderValue: PropTypes.string.isRequired,
    experiments: PropTypes.object.isRequired,
    children: PropTypes.node.isRequired,
};

const mapStateToProps = ({ experiments }) => ({
    experiments,
});

export class ExperimentContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            experimentValue: '',
        };
    }

    shouldComponentUpdate(nextProps, nextState) {
        if (nextState.experimentValue !== '') {
            return true;
        }
        return false;
    }

    componentWillMount() {
        const { experiments, uuid } = this.props;
        experiments.get(uuid).
            then(experimentValue => {
                this.setState({
                    experimentValue,
                });
            });
    }

    render() {
        const { experimentValue } = this.state;
        const { renderValue, children } = this.props;

        if (renderValue !== experimentValue || experimentValue === '') {
            return null;
        }

        return children;
    }
}

ExperimentContainer.propTypes = propTypes;

export const Experiment = connect(mapStateToProps)(ExperimentContainer);
