import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { hoveringOnUIElement, hoveringOffUIElement } from '../../../actions/ui';
import classNames from 'classnames';

export const TRANSITION_IN_CLASS = 'pl-hover-transition-in';
export const TRANSITION_OUT_CLASS = 'pl-hover-transition-out';
export const SHOW_ON_HOVER_CLASS = 'hover-display';

const propTypes = {
    children: PropTypes.node.isRequired,
    onHoverElement: PropTypes.func.isRequired,
    onHoverOffElement: PropTypes.func.isRequired,
    showUI: PropTypes.bool.isRequired,
};

const mapStateToProps = ({ ui }) => ({
    showUI: ui.showUI,
});

export const mapDispatchToProps = dispatch => ({
    onHoverElement() {
        dispatch(hoveringOnUIElement());
    },

    onHoverOffElement() {
        dispatch(hoveringOffUIElement());
    },
});

export class ShowOnHoverContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            classes: classNames(SHOW_ON_HOVER_CLASS),
        };
    }

    componentWillReceiveProps({ showUI }) {
        if (this.props.showUI && !showUI) {
            this.setState({
                classes: classNames(
                    SHOW_ON_HOVER_CLASS,
                    TRANSITION_OUT_CLASS
                ),
            });
        } else if (!this.props.showUI && showUI) {
            this.setState({
                classes: classNames(
                    SHOW_ON_HOVER_CLASS,
                    TRANSITION_IN_CLASS
                ),
            });
        }
    }

    render() {
        const { children, onHoverElement, onHoverOffElement } = this.props;

        return (
            <div
                onMouseEnter={onHoverElement}
                onMouseLeave={onHoverOffElement}
                className={this.state.classes}
            >
                {children}
            </div>
        );
    }
}

ShowOnHoverContainer.propTypes = propTypes;

export const ShowOnHover = connect(mapStateToProps, mapDispatchToProps)(ShowOnHoverContainer);
